/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.StandardCapabilities;
import com.quantumdata.sct.dao.jaxb.StandardCapabilitiesType;
import com.quantumdata.sct.dao.jaxb.StandardCapability;
import com.quantumdata.sct.dao.vo.StandardCapabilityVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.ArrayList;
import java.util.Iterator;

public final class StandardCapabilityDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    private StandardCapabilitiesType.StandardCapability get(Integer n) throws ReadException {
        if (n == null) {
            throw new ReadException("Invalid index");
        }
        int n2 = ((StandardCapabilities)this.daoObject).getElements().size();
        if (n >= n2) {
            throw new ReadException("Index out of bounds error");
        }
        StandardCapabilitiesType.StandardCapability standardCapability = (StandardCapabilitiesType.StandardCapability)((StandardCapabilities)this.daoObject).getElements().get(n);
        return standardCapability;
    }

    public void readCallback() throws DAOException {
        try {
            StandardCapabilities standardCapabilities = (StandardCapabilities)this.daoObject;
            int n = standardCapabilities.getElements().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                StandardCapabilitiesType.StandardCapability standardCapability = (StandardCapabilitiesType.StandardCapability)standardCapabilities.getElements().get(i);
                this.daoCollection.put(standardCapability.getStandardId(), new Integer(i));
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public final Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public final IPersistable getValueObjectForKey(Object object) throws CreateException {
        IPersistable iPersistable = null;
        try {
            if (!this.daoCollection.containsKey(object)) {
                throw new Exception("Element with key = " + object + " not found");
            }
            Integer n = (Integer)this.daoCollection.get(object);
            StandardCapabilitiesType.StandardCapability standardCapability = this.get(n);
            iPersistable = this.createPersistable(standardCapability);
        }
        catch (Exception exception) {
            throw new CreateException(exception.getMessage());
        }
        return iPersistable;
    }

    public final IPersistable[] findByAll() throws Exception {
        int n = ((StandardCapabilities)this.daoObject).getElements().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            StandardCapabilitiesType.StandardCapability standardCapability = (StandardCapabilitiesType.StandardCapability)((StandardCapabilities)this.daoObject).getElements().get(i);
            iPersistableArray[i] = this.createPersistable(standardCapability);
        }
        return iPersistableArray;
    }

    public final Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof StandardCapabilitiesType.StandardCapability) {
            StandardCapabilitiesType.StandardCapability standardCapability = (StandardCapabilitiesType.StandardCapability)object;
            object2 = standardCapability.getStandardId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    private IPersistable createPersistable(Object object) throws Exception {
        StandardCapabilityVO standardCapabilityVO = new StandardCapabilityVO();
        if (object instanceof StandardCapabilitiesType.StandardCapability) {
            this.copyFrom((StandardCapabilitiesType.StandardCapability)object, standardCapabilityVO);
        }
        return standardCapabilityVO;
    }

    private void copyFrom(StandardCapabilitiesType.StandardCapability standardCapability, StandardCapabilityVO standardCapabilityVO) throws Exception {
        standardCapabilityVO.setId(standardCapability.getStandardId());
        standardCapabilityVO.setLastUpdate(standardCapability.getLastUpdate());
        ArrayList<StandardCapabilityVO.StandardCapabilityElementVO> arrayList = new ArrayList<StandardCapabilityVO.StandardCapabilityElementVO>();
        int n = standardCapability.getCapabilities().size();
        for (int i = 0; i < n; ++i) {
            StandardCapability.StandardCapabilityElement standardCapabilityElement = (StandardCapability.StandardCapabilityElement)standardCapability.getCapabilities().get(i);
            StandardCapabilityVO.StandardCapabilityElementVO standardCapabilityElementVO = new StandardCapabilityVO.StandardCapabilityElementVO();
            standardCapabilityElementVO.setCapabilityId(standardCapabilityElement.getCapabilityId());
            standardCapabilityElementVO.setConformance(standardCapabilityElement.getConformance());
            standardCapabilityElementVO.setLocation(standardCapabilityElement.getLocation());
            standardCapabilityElementVO.setRequirement(standardCapabilityElement.getRequirement());
            arrayList.add(standardCapabilityElementVO);
        }
        standardCapabilityVO.setStandardElements(arrayList);
    }

    private void copyTo(StandardCapabilitiesType.StandardCapability standardCapability, StandardCapabilityVO standardCapabilityVO) throws Exception {
        standardCapability.setStandardId((String)standardCapabilityVO.getId());
        standardCapability.setLastUpdate(standardCapabilityVO.getLastUpdate());
        Iterator iterator = standardCapabilityVO.getStandardElements().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            StandardCapability.StandardCapabilityElement standardCapabilityElement = this.factory.createStandardCapabilityStandardCapabilityElement();
            StandardCapabilityVO.StandardCapabilityElementVO standardCapabilityElementVO = (StandardCapabilityVO.StandardCapabilityElementVO)iterator.next();
            standardCapabilityElement.setConformance(standardCapabilityElementVO.getConformance());
            standardCapabilityElement.setCapabilityId(standardCapabilityElementVO.getCapabilityId());
            standardCapabilityElement.setLocation(standardCapabilityElementVO.getLocation());
            standardCapabilityElement.setRequirement(standardCapabilityElementVO.getRequirement());
            standardCapability.getCapabilities().set(n, standardCapabilityElement);
            ++n;
        }
    }

    protected final void updateObject(IPersistable iPersistable) throws Exception {
        if (iPersistable instanceof StandardCapabilityVO) {
            StandardCapabilityVO standardCapabilityVO = (StandardCapabilityVO)iPersistable;
            Integer n = (Integer)this.daoCollection.get(standardCapabilityVO.getId());
            StandardCapabilitiesType.StandardCapability standardCapability = this.get(n);
            this.copyTo(standardCapability, standardCapabilityVO);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        StandardCapabilityVO standardCapabilityVO = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                StandardCapabilitiesType.StandardCapability standardCapability = this.get(n);
                standardCapabilityVO = new StandardCapabilityVO();
                this.copyFrom(standardCapability, standardCapabilityVO);
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            standardCapabilityVO = null;
        }
        return standardCapabilityVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                Integer n = (Integer)this.daoCollection.get(object);
                ((StandardCapabilities)this.daoObject).getElements().remove(n);
            }
            this.flush();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public final void add(IPersistable iPersistable) throws CreateException {
        this.add(iPersistable, 0);
    }

    public final void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            if (iPersistable instanceof StandardCapabilityVO) {
                StandardCapabilitiesType.StandardCapability standardCapability = this.factory.createStandardCapabilitiesTypeStandardCapability();
                this.copyTo(standardCapability, (StandardCapabilityVO)iPersistable);
                if (n > 0) {
                    ((StandardCapabilities)this.daoObject).getElements().add(n, iPersistable);
                } else {
                    ((StandardCapabilities)this.daoObject).getElements().add(iPersistable);
                }
            } else {
                throw new Exception("Invalid Value Object being passed");
            }
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

